<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('client_id', 'sender', 'receiver', 'delivery_id', 'discount', 'delivery_cost', 'total_cost', 'notes');

    public function client()
    {
        return $this->belongsTo('App\Models\Client');
    }

    public function delivery()
    {
        return $this->belongsTo('App\Models\Delivery');
    }

}